﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace EcuacionCuadraticaConVentana
{   // Inicio del NameSpace
    public partial class Form1 : Form
    {   // Inicio de la Clase

        public Form1()
        {   // InitializeComponent del Formulario
            InitializeComponent();
        }   // Fin InitializeComponent

        // Se definen las variables a Utilizar en toda la Aplicación.
        double dblCoefA, dblCoefB, dblCoefC;
        double dblDisc, dblRaizDisc, dblSol_X, dblSol_X1, dblSol_X2;
        string strMensaje;


        private void btnSalir_Click(object sender, EventArgs e)
        {   // Inicio Código del Botón Salir
            DialogResult DlgrOpcion;
            DlgrOpcion = MessageBox.Show("Esta seguro que quiere cerrar la Aplicación", "Salir de la Aplicación", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation);
            if (DlgrOpcion == DialogResult.Yes)
            {
                Close();    // Se cierra la aplicación
            }
        }   // Fin Código del Botón Salir

        private void btnLimpiar_Click(object sender, EventArgs e)
        {   // Inicio Código del Botón Limpiar
            lblCoefA.Text = "El Coeficiente A = ";  // Carga el texto por defecto del lblCoefA.
            lblCoefB.Text = "El Coeficiente B = ";  // Carga el texto por defecto del lblCoefB.
            lblCoefC.Text = "El Coeficiente C = ";  // Carga el texto por defecto del lblCoefC.

            lblCoefA.Visible = true;        // Y los muestra en la ventana.
            lblCoefB.Visible = true;
            lblCoefC.Visible = true;

            // Carga los textos por defectos de las labels que mostraran los Resultados
            lblSolucionUnica_X.Text = "Coeficiente A = 0, implica Ecuación Lineal y Solución Unica : X = ";
            lblSolucion_X1.Text = "Solución : X1 = ";
            lblSolucion_X2.Text = "Solución : X2 = ";
            lblSolucionCompleja.Text = "Discriminante < 0, implica Solucion Compleja. NO se CALCULA en esta Versión.";

            // Y la les quita la visibilidad para que no se vean hasta tener calculado el Resultado
            lblSolucionUnica_X.Visible = false;
            lblSolucion_X1.Visible = false;
            lblSolucion_X2.Visible = false;
            lblSolucionCompleja.Visible = false;

            btnIngresarDatos.Enabled = true;    // Despues de la limpieza se habilita el botón cargar datos.
            btnCalcular.Enabled = false; // Se DesHabilita el botón Calcular.    
        }   // Fin Código del Botón Limpiar

        private void btnIngresarDatos_Click(object sender, EventArgs e)
        {   // Inicio Código del Botón Ingresar Datos
            // Ingresa el Coeficiente A y lo Muestra
            strMensaje = "Ingrese el Valor Numérico del Coeficiente A: ";
            dblCoefA = funLeerNumero( strMensaje );  // Llama a funLeerNumero() para asegurarse de cargar un Número.
            lblCoefA.Text = lblCoefA.Text + Convert.ToString( dblCoefA );

            // Ingresa el Coeficiente B y lo Muestra
            strMensaje = "Ingrese el Valor Numérico del Coeficiente B: ";
            dblCoefB = funLeerNumero(strMensaje);   // Llama a funLeerNumero() para asegurarse de cargar un Número.
            lblCoefB.Text = lblCoefB.Text + Convert.ToString( dblCoefB );

            // Ingresa el Coeficiente C y lo Muestra
            strMensaje = "Ingrese el Valor Numérico del Coeficiente C: ";
            dblCoefC = funLeerNumero(strMensaje);   // Llama a funLeerNumero() para asegurarse de cargar un Número.
            lblCoefC.Text = lblCoefC.Text + Convert.ToString( dblCoefC );

            btnIngresarDatos.Enabled = false;   // Se desabilita el Botón de Carga de Datos.
            btnCalcular.Enabled = true; // Se habilita el botón Calcular.

        }   // Fin Código del Botón Ingresar Datos

        // inicio una función que recibe un parámetros string y retorna un Número double
        static double funLeerNumero(string funMensaje)
        {  // inicio funLeerNumero()

            string sNum;    // la funciòn define dos variables internas
            double dNum;    // una String para cargar el valor introducido que si es nùmero convierte a double.

            do
            {  // inicio ciclo While   

                // aquì usa el argumento strMensaje pasado al llamar la funciòn.
                // y llama a Microsoft.VisualBasic (que debe cargarse en Referencias) para usar InputBox()
                sNum = Microsoft.VisualBasic.Interaction.InputBox( funMensaje, ".:. Ingresar Valor Numérico .:." );
                // aquì lee el valor introducido por el Usuario, que es string.              
            } 
            while (!Microsoft.VisualBasic.Information.IsNumeric(sNum));  // el ciclo continua hasta que sNum sea un nùmero.
            dNum = Double.Parse(sNum); // si saliò del ciclo es xq sNum es un nùmero y lo convierte a double.
            return dNum;               // y retorna el valor al llamado de la funciòn.  

        }  // fin de funLeerNumero()

        private void btnCalcular_Click(object sender, EventArgs e)
        {   // Inicio Código del Botón Calcular

            if ( dblCoefA == 0.0 )  // Si coefA = 0, la Ecuación NO es cuadrática, Solo LINEAL. Evalua Sol_X_Unica.
            {   // Inicio IF
                dblSol_X = -dblCoefC / dblCoefB;    // Calculo la Solución Unica, la convierto a Texto y la Muestro.
                lblSolucionUnica_X.Text = lblSolucionUnica_X.Text + Convert.ToString(dblSol_X);
                lblSolucionUnica_X.Visible = true;
            }   // Fin IF

            else   // Si coefA != 0, la Ecuación ES cuadrática
            {   // Inicio ELSE
                dblDisc = Math.Pow( dblCoefB, 2 ) - (4 * dblCoefA * dblCoefC);    // Calculo el Discriminate.

                if ( dblDisc < 0 )  // Evalúo el Valor del Discriminante, Si Negativo, solución Compleja
                {   // Inicio if
                    lblSolucionCompleja.Visible = true; // y solo muestro un mensaje, porque NO se Calcula Complejos.
                }   // Fin if

                else
                {   // Inicio else
                    dblRaizDisc = Math.Sqrt(dblDisc);   // Calcula la Raiz Cuadrada del Discriminante.
                    dblSol_X1 = (-dblCoefB + dblRaizDisc) / (2 * dblCoefA); // calcula las Soluciones.
                    dblSol_X2 = (-dblCoefB - dblRaizDisc) / (2 * dblCoefA);
                    lblSolucion_X1.Text = lblSolucion_X1.Text + Convert.ToString(dblSol_X1);    // las convierte a String.
                    lblSolucion_X2.Text = lblSolucion_X2.Text + Convert.ToString(dblSol_X2);
                    lblSolucion_X1.Visible = true;  // y las Muestra.
                    lblSolucion_X2.Visible = true;
                }   // Fin else

                btnCalcular.Enabled = false; // Se DesHabilita el botón Calcular.

            }   // Fin ELSE
        }   // Fin Código del Botón Calcular

    }   // Fin de la Clase

}  // Fin del NameSpace
