﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace TP9_G12_Ej12
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Defino e inicializo varialbes globales (Tipo RAPTOR), que usaré en varios Módulos
        // A la Matriz/Vector, los Predefino antes de Conocer sus Dimensiones: 
        Double[,] DblMatriz;    // Pre-defino la Matriz, antes de conocer sus dimensiones
        Double[] DblVector;     // Pre-defino el Vector, antes de conocer su dimension
        Double D_Num;           // Defino el Número que retornará la FunLeerNum()
        Int16 M, N;             // Los Valores de Filas y Columnas de la Matriz (que uso en varios Módulos)
        String StrMensaje;      // El Mensaje que paso a la FunLeerNum()

        private Double FunLeerNum(string StrPrompt) // DEFINO la función Leer Número
        {   
            string StrNum; bool BoolBandera = true; // Defino variables locales para usar en la Funcion

            while (BoolBandera) // Inicio el Ciclo Mientras (Bandera sea verdadera)
            {  //Llamo a 2 Funciones de MS.VisualBasic: La Fun InputBox() y la IsNumeric(). OJO: Hay que Cargar Referencia.
                StrNum = Microsoft.VisualBasic.Interaction.InputBox(StrPrompt, "°° Ingreso de Datos °°", "5");

                if (Microsoft.VisualBasic.Information.IsNumeric(StrNum)) 
                {
                    D_Num = Convert.ToDouble(StrNum);   // Si el valor Retornado por InputBox() esNumeric(), lo convierto a Double
                    BoolBandera = false;    // cambio el valor de la Bandera para salir del Ciclo Mientras
                }   // Fin del if
            }       // Fin Ciclo Mientras 
            return D_Num;   // Retorno el Numero a quien llamó a la función
        }	// Fin funcion LeerNum

        private void BtnSALIR_Click(object sender, EventArgs e)
        {
            DialogResult DrOpcion;  // Declaro la Variable del tipo Resultado de la Opción de un MensajeBox
            DrOpcion = MessageBox.Show("¿Realmente quiere salir de la aplicación?", "Salir del Programa",
                                        MessageBoxButtons.YesNo, MessageBoxIcon.Question);

            if (DrOpcion == DialogResult.Yes) //Evaluo la Respuesta, Si es SI, muestro mensaje de Agradecimiento
            {
                MessageBox.Show("Gracias por usar la aplicación", "Salir del Programa",
                                MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
                Close();    // y salgo de la Aplicación
            }
        }

        private void BtnLIMPIAR_Click(object sender, EventArgs e)
        {
            CbbVector.Items.Clear();    // Limpia el Contenido del ComboBox
            CbbVector.Text = "Vector Nulo";    // Cambia el Título del ComboBox
            DgvMatriz.Rows.Clear(); //Limpio las Filas del DGV de la Matriz
            DgvMatriz.Columns.Clear(); //Limpio las Columnas del DGV de la Matriz
            DgvVector.Rows.Clear(); //Limpio las Filas del DGV del Vector
            DgvVector.Columns.Clear();  //Limpio las Columnas del DGV del Vector

            Nud_M.Value = 2; Nud_N.Value = 3;   //Repongo valores iniciales para Dimensionar Matriz

            // Además, controlo el estado de los Botones
            BtnCargar_MATRIZ.Enabled = true;    // Re-habilita el botón Cargar Matriz
            BtnCalcular_VECTOR.Enabled = false; // Despues de Limpiar Des-hablita el botón Calcular 
            BtnLIMPIAR.Enabled = false; // y DesHabilita el botón Limpiar            
        }

        private void BtnCargar_MATRIZ_Click(object sender, EventArgs e)
        {   // Inicio procedimiento Cargar_Matriz 
            M = Convert.ToInt16(Nud_M.Value);   // Obtenemos M (Filas) como n° NATURAL del NumUpDown
            N = Convert.ToInt16(Nud_N.Value);   // Obtenemos N (Columnas) como n° NATURAL 
            // Ahora que conozco la cantidad de elementos del Vector y Matriz, los Definimos así xq ya estaban PreDefinidos   
            DblMatriz = new Double[M, N];   // Sino, la Defino ASI: Double[,] DblMatriz = new Double[M, N];   
            DblVector = new Double[M];    // Defino el Vector  
            String StrColumna, StrFila; // Defino los contadores de Filas y Columnas como Texto para usar en el DGV
            for (int c = 0; c < N; c++)   {   // Creo las Columnas necesarias en el DGV            
                StrColumna = Convert.ToString(c);   // Convierto el Contador de Columnas a String
                DgvMatriz.Columns.Add("", StrColumna);    }      // Agrego las Columnas al DGV            
            // Preguntamos al Usuario por los elementos de la Matriz para cargarla
            for (int f = 0; f < M; f++) //Ciclo FOR para contar las Filas
            {
                DblVector[f] = 0;   // Asigno valor Nulo al 1er. elemento del Vector suma de Columnas
                StrFila = Convert.ToString(f);  //Convierto Nro. Fila a String
                DgvMatriz.Rows.Add();  //Agrego Fila a la DGV Matriz
                for (int c = 0; c < N; c++) //Ciclo FOR para contar las Columnas
                {
                    StrColumna = Convert.ToString(c);   //Convierto Nro. Columna a String
                    // Llamo a la función Leer Num para pedir el ingreso de un Número para M[f, c], al Usuario.
                    StrMensaje = "Ingrese el Elemento M( " + StrFila + " , " + StrColumna + " )";   //Genero el Mensaje
                    D_Num = FunLeerNum(StrMensaje); // Llamo a la función que me trae el Número de tipo double
                    DblMatriz[f, c] = D_Num;    // Asigno el Numero Retornado por la Función al elemento corresondiente de la Matriz
                    // Mostrar las Notas en el DataGridView                     
                    DgvMatriz.Rows[f].Cells[c].Value = String.Format("{0:#0.0}", DblMatriz[f, c]);
                    DblVector[f] = DblVector[f] + DblMatriz[f, c];  // Calculo la suma de columnas de c/Fila y la asigno al vector
                }   // Fin del ciclo por Columnas
            }       // Fin del Ciclo por Filas
            // Además, controlo el estado de los Botones al Terminar el Procedimiento con la Matriz Cargada
            BtnCargar_MATRIZ.Enabled = false;    // Des-habilita el botón Cargar Matriz
            BtnCalcular_VECTOR.Enabled = true;  // Habilita el botón Calcular
            BtnLIMPIAR.Enabled = true;  // Habilita el botón Limpiar
        }

        private void BtnCalcular_VECTOR_Click(object sender, EventArgs e) // Solo Muestra el Vector, xq ya lo Calculó en Linea 102
        {
            String S_Fila, S_Columna;   // Defino las variables internas del Módulo
                        //    OJO TODAS ESTA LÍNEAS SON  S O L O  PARA MODIFICAR EL ASPECTO DEL DGV. Si no van NO pasa NADA.
             // Para cambiar el formato de la Cabecera del DGV, 1ro. el FALSE en HeadersVisualStyle
             DgvVector.EnableHeadersVisualStyles = false;     // 1ro. el FALSE, y Ahora SI, cambiar las propiedades:
             DgvVector.ColumnHeadersDefaultCellStyle.BackColor = Color.LightSteelBlue;  //Cambia Color de Cabecera de Columnas
             DgvVector.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter; //Cambia Alineacion de Texto       
             DgvVector.DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight; // Alineamiento del resto de las Celdas.
             DgvVector.DefaultCellStyle.Font = new Font("Microsoft Sans Serif", 11);    // Establece tipo de Font y Tamaño
             DgvVector.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.DisplayedCells; //Columnas se adapten al ancho de las Celdas
             CbbVector.Items.Clear();    // Limpia el Contenido del ComboBox 
             CbbVector.Items.Add("V[i]".PadRight(10) + "Valor".PadRight(18)); // Mostramos Los Títulos de las Columnas en el ComboBox

            for (int c = 0; c < 1; c++) {   
                S_Columna = Convert.ToString(c);   // Convierto el Contador de Columnas a String
                DgvVector.Columns.Add("", S_Columna); }  // Agrego las Columnas al DGV
            // Preguntamos al Usuario por los elementos de la Matriz para cargarla
            for (int f = 0; f < M; f++)     {
                Int16 N_c = 0;  // Establezco la Columna donde mostraré los Datos del Vector Columna
                S_Fila = Convert.ToString(f);   // Convierto a String el Nro de Fila
                DgvVector.Rows.Add();  // Agrego una Fila 

                // Mostrando los Valores de la Suma en el DataGridView    
                DgvVector.Rows[f].Cells[N_c].Value = String.Format("{0:#0.0}", DblVector[f]);
                // Mostrando los Valores de la Suma en el ComboBox Agregando (Add) Items.
                CbbVector.Items.Add(S_Fila.PadRight(10) + String.Format("{0:#0.0}", DblVector[f]));
            }
            CbbVector.Text = "Ver Vector";    // Cambio el Título del ComboBox
            BtnCalcular_VECTOR.Enabled = false;  // Habilita el botón Calcular
        }   //Fin BtnCalcular_VECTOR
    }       // FIN public partial class Form1
}           // FIN namespace TP9_G12_Ej12
