﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace TP10_G12_Ej12
{
    public partial class FrmRaiceMétodoIterativo : Form
    {
        public FrmRaiceMétodoIterativo()
        {
            InitializeComponent();
        }

        // Inicializo variables Globales
        double Num_m, Num_Xn, Num_Xm, Error;
        Int16 IntCont = 1;

        private void BtnLimpiar_Click(object sender, EventArgs e)
        {
            CbxRaizCuadrada.Items.Clear();  // Limpio los valores del ComboBox
            CbxRaizCuadrada.Text = "Sin Datos"; // Cambio el Título del ComboBox
            Nud_Num.Value = 2;  //Repongo valores iniciales
            LblSolucion1.Text = "Raiz Cuadrada = ";
            CbxRaizCubica.Items.Clear();  // Limpio los valores del ComboBox
            CbxRaizCubica.Text = "Sin Datos"; // Cambio el Título del ComboBox
            Nud_Num.Value = 2;  //Repongo valores iniciales
            LblSolucion2.Text = "Raiz Cúbica = ";
            IntCont = 1;

            // Además, controlo el estado de los Botones
            BtnCalcular.Enabled = true;
            BtnLimpiar.Enabled = false;
        }

        private void BtnSalir_Click(object sender, EventArgs e)
        {
            DialogResult DrOpcion;  // Declaro la Variable del tipo Resultado de la Opción de un MensajeBox
            DrOpcion = MessageBox.Show("¿Realmente quiere salir de la aplicación?", "Salir del Programa",
                                        MessageBoxButtons.YesNo, MessageBoxIcon.Question);

            if (DrOpcion == DialogResult.Yes) //Evaluo la Respuesta, Si es SI, muestro mensaje de Agradecimiento
            {
                MessageBox.Show("Gracias por usar la aplicación", "Salir del Programa",
                                MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
                Close();    // y salgo de la Aplicación
            }
        }        

        private void BtnCalcular_Click(object sender, EventArgs e)
        {
            // Inicializo variables para el cálculo de la RAIZ_CUADRADA 
            string StrMensaje;           
            Error = 1E-10;     IntCont = 1;    // Inicializo el contador de ITERACIONES
            Num_m = Convert.ToDouble(Nud_Num.Value);    Num_Xn = 1; // valor inicial primera ITERACIÓN
            Num_Xm = (1.0/2) * (Num_Xn + (Num_m / Num_Xn));   // Calculo 2da. Iteración         

            // Muestra Linea cabecera y el Valor de las ITERACIONES en el ComboBox
            CbxRaizCuadrada.Items.Add("X[ i ]".PadRight(8) + "Valor".PadRight(15)); //Linea de Título
            CbxRaizCuadrada.Items.Add("X[0]".PadRight(7) + String.Format("{0:#0.0000000000}", Num_Xn));
            CbxRaizCuadrada.Items.Add("X[1]".PadRight(7) + String.Format("{0:#0.0000000000}", Num_Xm));

            while (!(Math.Abs(Num_Xm - Num_Xn) < Error))    // Inicio el CICLO para Raiz CUADRADA
            {
                IntCont++;  // Incremento contador de Iteraciones
                StrMensaje = "X["+ Convert.ToString(IntCont) +"]";
                Num_Xn = Num_Xm;    // Paso nueva Iteración a Iteración anterior
                Num_Xm = 0.5 * (Num_Xn + (Num_m / Num_Xn));  // Calculo Nuevas Iteraciones  
                // En el ciclo Siguo agregando el Valor de las ITERACIONES en el ComboBox
                CbxRaizCuadrada.Items.Add(StrMensaje.PadRight(7) + String.Format("{0:#0.0000000000}", Num_Xm));
            }

            LblSolucion1.Text = LblSolucion1.Text + Num_Xm; // Muestro el valor de la Raiz Cuadrada
            // FINALIZO el cálculo de la RAIZ_CUADRADA 


            // Inicio el CALCULO para Raiz CUBICA
            IntCont = 1;    // Inicializo el contador de ITERACIONES
            Num_Xn = 1; // valor inicial primera ITERACIÓN
            Num_Xm = (1.0/3.0) * (2 * Num_Xn + (Num_m / (Num_Xn * Num_Xn)));  //Calculo Nueva ITERACION          

            // Muestra Linea cabecera y el Valor de las ITERACIONES en el ComboBox
            CbxRaizCubica.Items.Add("X[ i ]".PadRight(8) + "Valor".PadRight(15)); //Linea de Título
            CbxRaizCubica.Items.Add("X[0]".PadRight(7) + String.Format("{0:#0.0000000000}", Num_Xn));
            CbxRaizCubica.Items.Add("X[1]".PadRight(7) + String.Format("{0:#0.0000000000}", Num_Xm));

            while (!(Math.Abs(Num_Xm - Num_Xn) < Error))
            {
                IntCont++;
                StrMensaje = "X["+ Convert.ToString(IntCont) +"]";
                Num_Xn = Num_Xm;
                Num_Xm = (1.0 / 3) * (2 * Num_Xn + (Num_m / (Num_Xn * Num_Xn)));  //Calculo Nueva ITERACION 
                // En el ciclo Sigue agregando el Valor de las ITERACIONES en el ComboBox
                CbxRaizCubica.Items.Add(StrMensaje.PadRight(7) + String.Format("{0:#0.0000000000}", Num_Xm));
            }

            LblSolucion2.Text = LblSolucion2.Text + Num_Xm; // Muestro el valor de la Raiz Cuadrada

            CbxRaizCuadrada.Text = "Ver ITERACIONES"; // Cambio el Título del ComboBox
            CbxRaizCubica.Text = "Ver ITERACIONES"; // Cambio el Título del ComboBox

            // Además, controlo el estado de los Botones
            BtnCalcular.Enabled = false;
            BtnLimpiar.Enabled = true;
        }
    }
}
